# 可选步骤：conda使用前的配置

## 简介

本节内容是针对不同用户的电脑硬盘大小和网络情况等因素对conda进行配置的内容，包括把虚拟环境的存储路径修改到容量更大的硬盘、将conda的下载源修改为国内的镜像源以提高下载速度的方法等内容。

本节内容皆为需要根据自身需求进行设置的可选性内容，请按需修改。

本节内容并不是只包含conda使用“前”的配置内容，也根据实际使用需求提供了迁移虚拟环境的方法等。

## 修改/迁移conda的虚拟环境的保存路径

虚拟环境的所有内容都打包在一个文件夹中，可以很方便的进行手动迁移

如果有需要迁移的环境，首先使用`conda env list`列出环境列表，其中也包含环境的当前路径。

然后添加一个新的路径作为conda检索和新建虚拟环境的路径，具体说明见下图。

![conda虚拟环境路径](img/conda虚拟环境路径配置.png)

## 设置镜像下载源

conda在创建和维护虚拟环境时，需要联网查找和下载所需的各种资源，由于conda（和其他类似的需要互联网下载服务的开发工具）的下载源服务器位置在国外，因此国内一些大学和公司提供了镜像下载源网站服务于国内开发人员。

conda本身也提供了使用指令修改自身下载源的设置方法，复制下方指令逐个添加即可。

```zsh
# 推荐设置：下载包时显示所有镜像源
conda config --set show_channel_urls yes

# 以下为conda的清华镜像下载源
conda config --add channels https://mirrors.tuna.tsinghua.edu.cn/anaconda/cloud/pytorch/

conda config --add channels https://mirrors.tuna.tsinghua.edu.cn/anaconda/cloud/conda-forge/

conda config --add channels https://mirrors.tuna.tsinghua.edu.cn/anaconda/pkgs/free/

conda config --add channels https://mirrors.tuna.tsinghua.edu.cn/anaconda/cloud/msys2/

conda config --add channels https://mirrors.tuna.tsinghua.edu.cn/anaconda/pkgs/r/

conda config --add channels https://mirrors.tuna.tsinghua.edu.cn/anaconda/pkgs/main/
```

## 补充：使用pip下载时临时指定下载源的方法

以清华源为例：在安装指令的末尾添加`-i https://mirrors.tuna.tsinghua.edu.cn/pypi/web/simple`即可，示例如下：

```zsh
# 原指令
pip install numpy
# 使用镜像源的指令
pip install numpy -i https://mirrors.tuna.tsinghua.edu.cn/pypi/web/simple
```
