# Linux操作系统入门

本节内容主要提供给有Linux使用需求而又不了解Linux操作系统的同学参考。  

提示：

- `` ` ``是在键盘左上方边缘、`TAB`的上面、`1`的左边、`ESC`的下面的那个键
- `~`是`shift`+`` ` ``
- windows的路径中的斜杠是`\`，而linux的路径中的斜杠是`/`，注意区分。
- `\`在`Enter`键上面、退格键下面，`/`在右`shift`左边，`M`键右右右边。
- 以上键输入时请用英文输入法

## linux操作系统种类介绍

我们经常接触的电脑端的linux操作系统一般有以下几类

- wsl/服务器端的linux操作系统
  - 此类操作系统一般只通过bash shell进行控制，也就是环境配置过程中全程都在面对`bash shell`的窗口。
  - 服务器端的使用需求一般是连接实验室/个人linux服务器和租用云GPU服务器
- 图形化界面的linux操作系统
  - 可以通过鼠标键盘点击各种图标进行操作，和windows操作系统相同，当然，也可以使用`bash shell`进行配置。
  - 使用wsl+远程操作是更为方便的配置linux环境的方法。
  - 图形化界面操作系统的主要存在价值是具有和windows操作系统竞争的潜力，

很显然，掌握`bash shell`的基本用法是使用linux操作系统的最基本能力。

## bash介绍

### bash shell是用来做什么的

- bash shell和鼠标键盘的基本功能一样：都是用来操作“操作系统”的工具。从最基本的查看、复杂粘贴文件，到对电脑的各种软硬件进行安装配置，都可以通过在bash shell中输入指令完成。事实上，在鼠标和windows发明之前，电脑的主要操作方式就是使用命令行。
- 学习bash shell其实就是在学习bash shell的各种功能的指令的用法。
- 上面的表述同样适用于windows的cmd和powershell。

### bash shell页面介绍

- bash shell的标志性特征是`用户名@计算机名：~$`。当看到`$`结尾的命令行时，就说明后面要输入的指令应当是“linux指令”。
  - 在使用root用户时，前面的标记会变成`#`，例如`root@计算机名：~#`,某些情形下也可能会带中括号`[root@计算机名]：~#`。
- 在完成conda的环境配置后，前面会增加已激活环境的标记，例如`(base) 用户名@计算机名：~$`。
- 额外科普
  - 类似的，cmd打开时的页面一般为`C:\Users\用户名>`
  - powershell则会比cmd多一个`PS`标记：`PS C:\Users\用户名>`
  - linux的目录斜杠与windows的是相反的，往下看就会发现。
- 萌新注意
  - 不要手动输入`$`

## linux的基本操作

以下是常用指令和接下来linux环境配置会被用到的指令的说明

当你打开/远程连接一个linux服务器

### 目录操作

linux操作系统的根目录的标记为`/`、linux当前用户的目录为`~`

目录操作是最基本的指令，常用命令如下

- 专供查询，不需要背，用多了自然熟练。
- 以下命令，在成功执行后一般不会出现诸如“操作完成、删除完成”之类的废话，出现新的命令行就说明执行成功了。

常用基本目录操作命令

```bash
# 列出当前目录的文件/文件夹名（新版，彩色渲染）
ls
# 列出当前目录的文件/文件夹名（更旧的指令）
dir

# 返回上级目录，如果已经在根目录/则森么也不做
cd .. 

# ====================
# 使用绝对路径的方式切换目录
# 第一个字符是/就是绝对路径
# 这个指令可以在任意目录时切换到指定目录
cd /home/wlm/abc

# 进入根目录。权限不足可能会失败
cd /

# 进入用户目录中的abc文件夹
# linux系统中~代表
cd ~/abc

# ====================
# 使用相对路径的方式
# 第一个字符不是/就是相对路径
# 如果当前目录是/aaa则执行后会进入目录/aaa/abc
cd abc

# ====================
# 进入用户的个人目录
# 这个指令同样可以在任意目录时使用
cd ~

# 这个指令同样可以后接子目录
cd ~/abc

# ====================

# 以abc为例举例删除和创建文件夹的操作
# 创建一个名为abc的文件夹
mkdir abc

# 删除文件/文件夹（可以先用dir指令列出名字）
rm -r abc

# 删除文件（安全删除：如果这是个文件夹会删除失败）
rm abc

# 删除空文件夹（安全删除：文件夹非空会删除失败）
rmdir abc

# 创建文件操作：请用vscode， 此处略

# 打印当前目录的绝对路径
# 主要有用的点就是能够打印~目录的绝对路径
pwd
```

如需要更多命令可以在搜索引擎搜索`linux命令手册`之类的关键词进行搜索。

### 接下来环境配置时会用到的指令说明

下面的这些指令会在接下来环境配置的过程中进行用到，你可以先阅读一下下面的内容以便在用到时理解指令的含义，或者在需要时进行查阅，当然不阅读下面的指令也是可以完成环境配置的，只是对于某些零基础学员来说，可能会配置的一头雾水。

```bash

```