# 操作系统调整

## 中文用户名BUG

英文名用户可以跳过本节。  
已知bug：  
windows操作系统中conda+powershell+中文用户名的组合会由于中文字符问题导致conda无法正常使用。  
这个组合是接下来环境配置需要用到的，为了避免出现不必要的麻烦，中文名用户需要在开始环境配置之前对该问题进行处理。  
解决方法：

- 方案一：新建英文名的管理员账户安装和配置环境
  - 特点：可彻底解决该问题，但操作繁琐。适合熟悉电脑的用户操作。  
  - 大致步骤：`找到账户设置->添加英文名新账户->给予管理员权限->重启登录新账户->（可选）备份文件并删除旧账户`，需要备份的是`C:\Users\旧用户名`文件夹。方法步骤不唯一。
  - 更具体的操作步骤
    - 左下角开始->设置->账户->家庭和其他账户->无视家庭成员、点击下方将其他人添加到这台电脑->输入英文用户名（可以不输入密码）->点击下一步直到完成创建->更改账户类型为管理员->注销或重启以登录新账户
    - 在了解操作后果的前提下可以备份并删除旧帐户（可选操作，谨慎操作，不了解操作后果不建议进行删除操作，后果包括但不限于部分软件需在新账户重装、重新登录、重新设置、个人文件夹中保存的数据文档丢失等）。  
  - 使用控制面板或win+R打开运行->输入`netplwiz`进行设置也是可选方案
- （方案二经过测试，依然会出现其他非常麻烦的bug，文案暂时保留，但不推荐使用。）
- ~~方案二：使用anaconda prompt（cmd）作为默认shell~~
  - ~~特点：操作简单保守，无其他副作用，但不排除使用其他软件时再次遇到中文bug，但日常使用时可能更不方便，推荐电脑个人数据较多或电脑小白选择方案二进行操作。~~
  - ~~基本思路：不再配置powershell，改为使用`conda prompt`或cmd作为替代，并修改虚拟环境的保存路径为英文。~~
  - ~~具体操作步骤~~
    - ~~conda安装完成后立刻打开`anaconda prompt`并输入指令`conda config --add envs_dirs C:\my_conda_env`将创建虚拟环境的路径改为英文路径，这里的C盘路径可以自行修改为自己容量最大的盘。~~
    - ~~后续所有遇到`powershell`字样的操作步骤全部改为使用`anaconda prompt`进行操作，并省掉`conda init`步骤。（中文路径不要使用conda init指令，会造成更多问题！）~~
  - ~~补充：vscode安装成功后的后续优化操作~~
    - ~~使用cmd作为vscode默认shell终端的方法：ctrl+,或点击左下角打开设置->搜索`terminal.integrated.defaultProfile.windows`->选择command prompt。~~
    - ~~该方案理论上可以避免在使用vscode时频繁打开独立的`anaconda prompt`窗口~~
- 不建议直接修改用户名或其他方案，会造成更多的隐患和bug导致系统不稳定。  

## 设置windows开发者选项

以下设置为推荐设置，会减少未来环境配置和代码学习时遇到问题的频率，特别推荐修改powershell安全策略和文件扩展名的设置。

1. 按`win`键、或开始菜单、或桌面空白处右键显示设置->左上角跳转到设置主页、或搜索栏搜索“设置”，总之找到设置选项。
2. 在windows设置页面搜索“开发者”、或点击`更新与安全->开发者选项`跳转到开发者选项。
3. 推荐勾选以下修改项
   - 文件资源管理器
     - 更改设置以显示文件扩展名——勾选
     - 更改设置以显示隐藏文件和系统文件——勾选
     - 更改设置以在标题栏中显示完整路径——勾选
   - 远程桌面
     - 按需修改
   - powershell
     - 更改执行策略，以允许本地powershell脚本在未签名的情况下运行。——勾选
       - 如果不修改本项，则会在使用powershell环境执行conda指令时遇到麻烦。虽然可以使用`conda prompt`作为替代，但使用`powershell`更为灵活、便利和一劳永逸。

### 修改powershell安全策略的另一种方法

- 组合键`win+r`->输入`powershell`->使用`ctrl+shift+enter`以管理员权限打开->复制并执行指令：

```powershell
set-executionpolicy remotesigned
# 回车后输入A选择全是，并再次回车
```
