# pytorch环境配置linux版

conda安装完成后，我们只需要正常使用conda指令配置linux环境即可。

```bash
conda create -n aaaa
conda activate aaaa
```

## 检查自己的cuda版本

在bash shell中输入

```bash
nvidia-smi
```

### 指令成功执行

查看右上角自己的`CUDA Version`确定自己能安装的最高cuda版本，比如我的是12.2，所以我选择pytorch-cuda版本时不能大于12.2。  

![GPU检查图，linux版](img/GPU_check.png)

### 指令执行失败

没有N卡，只能安装CPU版torch
如果你是使用虚拟机运行的linux导致的无法识别GPU，则建议改为使用wsl

## GPU版torch安装

进入pytorch官网：`https://pytorch.org/`并往下拉，找到以下页面：

![pytorch官网安装指令页面](img/pytorch_index.png)

- pytorch安装的cuda版本不能高于自己的`CUDA Version`，在此基础上在上方页面选择安装版本。建议选择conda安装，使用pip可能由于conda的机制造成意料之外的结果。
  - “意料之外的结果”的说明：conda在创建环境时默认不会立刻安装python，因此新的环境中不存在pip，使用pip指令时会由于环境变量的优先级机制，匹配到上一层环境的pip，因此使用pip指令在新环境安装时可能会将库安装到错误的环境中。
  - 避免此问题的方法：在新环境使用`pip`之前先执行`conda install python=3.xx`安装python，等号后面的`3.xx`是具体的python版本号，可省略，但建议加上。
- 国内用户使用conda安装pytorch时需要在换源后需要删除其中的`-c pytorch`方能正常使用镜像源下载。  
  - 注意镜像源经常会匹配版本失败导致在指定为cuda版本的前提下依然下载成CPU版。有条件的建议切换成国外网络环境。该问题在windows操作系统上存在，linux操作系统未经过测试。
- 如果自己的cuda版本过低，可以点击上图左下角的`previous versions of PyTorch`按钮查找不高于自己cuda版本的其他版本安装指令。

## CPU版torch安装

要求：

- 已正常安装conda并按要求配置好镜像源（如果需要）。
- 已激活虚拟环境。

```bash
# 已配置镜像源：
conda install pytorch torchvision torchaudio cpuonly
# 使用官方源：
conda install pytorch torchvision torchaudio cpuonly -c pytorch
```

## 检查pytorch安装情况

pytorch安装完成后，输入下方指令并稍等片刻，返回cuda支持情况以确定pytorch是否安装成功。

```bash
python -c "import torch;print(torch.cuda.is_available())"
# 安装GPU版pytorch返回应当为True  
# 安装CPU版pytorch返回应当为False  

# 这个指令的功能相当于重启了shell
. ~/.bashrc
```

```bash
python -c "import torch;print(torch.__version__)"
# 正常情况应当返回torch版本2.x.x，过旧的cuda版本可能会是1.x.x
```

若输出符合预期则pytorch配置完毕。若输出与预期不符则可能为环境配置步骤中的某步出问题，需要进行检查。

## 安装其他第三方库

- 第三方库的安装主要要注意点在于安装时的名称与常用称呼可能不一致，例如`sklearn`在安装时要使用全程`scikit-learn`。
- 以下是一些深度学习常用第三方库的安装指令示例，注意不要安装到base环境中。

```bash
conda install numpy
conda install pandas
conda install matplotlib
conda install seaborn
conda install scipy
conda install scikit-learn
# 也可以合并为一句
conda install numpy,pandas,matplotlib,seaborn,scipy,scikit-learn
```
