# WSL2的安装与配置

## 步骤一：操作系统版本检查

首先进行版本检查：

- win11肯定能用
- win10：
  win+R输入`winver`查看操作系统内部版本号
  >对于 x64 系统：版本 1903 或更高版本，内部版本为 18362.1049 或更高版本。
  >对于 ARM64 系统：版本 2004 或更高版本，内部版本为 19041 或更高版本。

请顺便记一下你是x64还是ARM64，后面要用。

## 步骤二：操作系统设置调整

wsl是微软开发的，在windows上已有但需要手动启动的一个功能。微软已经帮你准备好了启用指令。

win+R打开运行，输入powershell，ctrl+shift+enter以管理员权限打开。然后输入以下指令：

```powershell
dism.exe /online /enable-feature /featurename:Microsoft-Windows-Subsystem-Linux /all /norestart
dism.exe /online /enable-feature /featurename:VirtualMachinePlatform /all /norestart
```

- 第一个指令的含义是启用wsl
- 第二个指令的含义是启用虚拟机平台。

重启电脑然后下一步。

## 步骤三：下载安装WSL2

点击下载x64或ARM64的安装包：

- x64：
  <https://wslstorestorage.blob.core.windows.net/wslblob/wsl_update_x64.msi>
- ARM64：
  <https://wslstorestorage.blob.core.windows.net/wslblob/wsl_update_arm64.msi>

下载完成后安装。

安装完成后，在powershell中输入下方指令，设置wsl创建linux子系统时的默认版本为2

```powershell
wsl --set-default-version 2
```

## 步骤四：安装linux子系统

- 你可以直接使用`wsl --install`安装默认的ubuntu发行版
- 也可以使用`wsl --list --online`来列出所有可选的linux发行版，然后使用`wsl --install -d <linux发行版名称>`来安装，下面是示例
  ![使用powershell安装linux子系统](img/linux子系统shell安装.png)

注意：

- linux子系统的最大大小约1G，小的只有100M出头。
- 不需要使用梯子，用梯子反而会减速。
- 安装时长大约三分钟以内，安装完成后会提示你创建用户名和密码。某些版本在安装时可能会直接假死，5分钟后没安装成功直接关掉即可，目前测试结构为不影响正常使用，只是登陆时直接就是root用户。

### 附：手动下载安装linux子系统的方法

如果遇到下载问题（例如下载过慢），可用考虑手动下载安装linux子系统。

先下载linux子系统文件，下面是各linux子系统发行版的手动下载链接

>[默认的Ubuntu版本 目前是22.04 LTS 大小1.0G](https://aka.ms/wslubuntu)  
>[Ubuntu 24.04 大小667M](https://wslstorestorage.blob.core.windows.net/wslblob/Ubuntu2404-240425.AppxBundle)  
>[Ubuntu 22.04 LTS 大小1.0G](https://aka.ms/wslubuntu2204)  
>[Ubuntu 20.04 大小895M](https://aka.ms/wslubuntu2004)  
>[Ubuntu 20.04 ARM 大小400M](https://aka.ms/wslubuntu2004arm)  
>[Ubuntu 18.04 大小221M](https://aka.ms/wsl-ubuntu-1804)  
>[Ubuntu 18.04 ARM 大小201M](https://aka.ms/wsl-ubuntu-1804-arm)  
>[Ubuntu 16.04 大小199M](https://aka.ms/wsl-ubuntu-1604)  
>[Debian GNU/Linux 大小167M](https://aka.ms/wsl-debian-gnulinux)  
>[Kali Linux 大小397M](https://aka.ms/wsl-kali-linux-new)  
>[SUSE Linux Enterprise Server 12 大小199M](https://aka.ms/wsl-sles-12)  
>[SUSE Linux Enterprise Server 15 SP2 大小159M](https://aka.ms/wsl-SUSELinuxEnterpriseServer15SP2)  
>[SUSE Linux Enterprise Server 15 SP3 大小194M](https://aka.ms/wsl-SUSELinuxEnterpriseServer15SP3)  
>[openSUSE Tumbleweed 大小183M](https://aka.ms/wsl-opensuse-tumbleweed)  
>[openSUSE Leap 15.3 大小175M](https://aka.ms/wsl-opensuseleap15-3)  
>[openSUSE Leap 15.2 大小141M](https://aka.ms/wsl-opensuseleap15-2)  
>[Oracle Linux 8.5 大小109M](https://aka.ms/wsl-oraclelinux-8-5)  
>[Oracle Linux 7.9 大小125M](https://aka.ms/wsl-oraclelinux-7-9)  
>[Fedora Remix for WSL 大小570M，github](https://github.com/WhitewaterFoundry/WSLFedoraRemix/releases/)  

下载完成之后通过浏览器找到下载文件所在文件夹，在文件夹空白处按住shift+鼠标右键，选择“在此处打开powershell窗口”，然后输入以下指令：

```powershell
# 将app_name替换为你下载的appx包名
Add-AppxPackage .\app_name.appx
```

## 检查和启动wsl的linux子系统

列出所有的linux子系统

```powershell
wsl -l -v
```

启动linux子系统

```powershell
# 启动默认的linux子系统
wsl

# 启动某个特定的linux子系统：
wsl -d <linux发行版名称>

# 退出子系统
exit

# 提示：linux子系统安装完成后，不需要在powershell中启动
# 你可以直接通过vscode远程连接linux子系统的方式操作linux
```

>附微软官方中文wsl安装使用参考教程
><https://learn.microsoft.com/zh-cn/windows/wsl/install-manual>
