# vscode、pycharm与jupyter介绍

## 深度学习的“开发环境”简介

- 我们使用的“开发环境”通常由两个部分组成：代码“编写”环境和代码“运行”环境。
  - 我们“运行代码”使用的是“conda的虚拟环境”，“编写代码”使用的则是pycharm或vscode（二选一即可）
  - “写代码”和“运行代码”是基本上互不干涉的两件事，只不过pycharm和vscode作为“集成”开发环境，均可以识别和调用conda的虚拟环境（或者python环境）执行代码。
- 如果没有conda，vscode和pycharm依然可以编写代码，但无法执行代码。
- 如果只有conda没有vscode或pycharm，则可以运行已有的代码，但不方便编写（代码作为纯粹的文本，仅用txt文档等工具也是可以编写的...但何必呢？）

## vscode与pycharm

- vscode与pycharm是同类产品，都属于IDE（集成开发环境，集成了一些方便写代码和调试代码的工具）。因此pycharm和vscode二选一即可。
- vscode与pycharm的功能基本相同，使用vscode与使用pycharm的用户共同工作时出现的沟通问题只有入门阶段的一些操作区别问题。
- vscode的特点是免费、轻量级、可高度自定义、多编程语言通用
- pycharm是python专用，只支持python一种语言，有免费版和付费版。

由于pycharm的内置jupyter和远程连接功能是付费功能，而同样的功能在vscode免费，因此本文档更推荐新人使用vscode作为推荐配置，但如果你已经熟悉pycharm也可以继续选择pycharm。

## jupyter

- jupyter是一个适用于代码展示和教学的工具，其基本功能为逐块运行代码和展示输出结果。
- jupyter也适用于书写笔记和分享。
- jupyter和vscode一样需要指定使用哪个conda的虚拟环境运行python代码。  
- 为了让conda的虚拟环境能够“配合”jupyter，需要在虚拟环境中额外安装“ipykernel”库，（每个需要使用jupyter的虚拟环境都要安装一次）。  
- jupyter既可以单独使用，也可以以插件的形式嵌入到vscode中（推荐后者）

## conda

conda负责运行代码的工作。

由于软件版本更新迭代和开发团队的不同、代码的重复利用等因素，导致不同的实际项目所需要的环境经常会出现“不兼容”的现象，因此基于实践经验找到的最优工作方式就是“每个软件项目都单独定制一个代码运行环境”。conda提供的功能就是“可以同时方便的维护多个不同的python代码的执行环境并使其互不影响”。

- 简单理解就是，运行代码的python解释器也需要安装类似“插件”的各种库增加对应的扩展功能。
- 这些“插件”由于来自不同的开发团队，混用起来容易出现各种逻辑上的冲突。
- 因此每个项目的执行环境都需要独立定制。

声明：这里的“插件”不是术语，是比喻，正式说法是“库”或“包”，但其实都是类似的东西。

## pytorch

pytorch是python的第三方库，也就是上文所说的类似“插件”一样的可以添加到python环境中的工具包，也是深度学习框架的核心软件包。

pytorch分为GPU版和CPU版。

- GPU（电脑显卡，也叫显示适配器）和CPU（中央处理器）都是电脑中负责运算工作的硬件。
- GPU版和CPU版分别调用电脑的GPU或CPU处理人工智能算法模型的各种相关运算任务。
- GPU版运算性能高，运算速度快，但GPU价格昂贵，不是所有电脑都具备使用GPU版pytorch的条件。
  - 在实际需要时也可以租用云GPU服务器作为替代方案。
- CPU是电脑的核心硬件，是每台电脑都必须具备的硬件，因此所有计算机都支持CPU版。

关于pytorch的更多介绍会在windows深度学习环境搭建的步骤4中提到。
