# 在linux上安装conda

## 前置条件

首先打开linux操作系统的bash shell页面，正常linux开机登录之后就是，桌面端为右键桌面空白处然后选择终端，方法不唯一。

所有的操作都在这个bash shell中完成。

可以在bash shell中使用`arch`或`getconf LONG_BIT`查看自己的处理器架构。

## conda配置步骤

- 首先在bash shell中使用`arch`或`getconf LONG_BIT`查看linux端的处理器架构类型。
  - 我们需要根据处理器架构信息选择适合自己的安装包。
  - 细节提示：注意x86_64为64位，x86为32位，两种x86不要混淆。
- 然后根据上面的信息，复制下方其中一个指令进行下载和安装。
  - 链接尾部就是对应的处理器架构类型，请自行检查匹配
  - 指令说明：`wget`负责下载，`bash`负责安装。
    - 请先执行`wget`那一行，再执行`bash`那一行
  - 前面是官方源，往下拉还有清华源，请按需选择。

官方源

```bash
wget -c https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86_64.sh
bash Miniconda3-latest-Linux-x86_64.sh
```

```bash
wget -c https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-x86.sh
bash Miniconda3-latest-Linux-x86.sh
```

```bash
wget -c https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-s390x.sh
bash Miniconda3-latest-Linux-s390x.sh
```

```bash
wget -c https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-aarch64.sh
bash Miniconda3-latest-Linux-aarch64.sh
```

```bash
wget -c https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-ppc64le.sh
bash Miniconda3-latest-Linux-ppc64le.sh
```

```bash
wget -c https://repo.anaconda.com/miniconda/Miniconda3-latest-Linux-armv7l.sh
bash Miniconda3-latest-Linux-armv7l.sh
```

清华镜像源

```bash
wget -c https://mirrors.tuna.tsinghua.edu.cn/anaconda/miniconda/Miniconda3-latest-Linux-x86_64.sh
bash Miniconda3-latest-Linux-x86_64.sh
```

```bash
wget -c https://mirrors.tuna.tsinghua.edu.cn/anaconda/miniconda/Miniconda3-latest-Linux-x86.sh
bash Miniconda3-latest-Linux-x86.sh
```

```bash
wget -c https://mirrors.tuna.tsinghua.edu.cn/anaconda/miniconda/Miniconda3-latest-Linux-s390x.sh
bash Miniconda3-latest-Linux-s390x.sh
```

```bash
wget -c https://mirrors.tuna.tsinghua.edu.cn/anaconda/miniconda/Miniconda3-latest-Linux-aarch64.sh
bash Miniconda3-latest-Linux-aarch64.sh
```

```bash
wget -c https://mirrors.tuna.tsinghua.edu.cn/anaconda/miniconda/Miniconda3-latest-Linux-ppc64le.sh
bash Miniconda3-latest-Linux-ppc64le.sh
```

```bash
wget -c https://mirrors.tuna.tsinghua.edu.cn/anaconda/miniconda/Miniconda3-latest-Linux-armv7l.sh
bash Miniconda3-latest-Linux-armv7l.sh
```

提示：你也可以直接在网页打开这两个链接，手动选择版本号下载。

<https://repo.anaconda.com/miniconda/>
<https://mirrors.tuna.tsinghua.edu.cn/anaconda/miniconda/?C=M&O=D>

- `wget`和`bash`指令执行后，首先会弹出安装协议，长按enter快速跳过，一直到显示"yes or no"选项
  - 输入`yes`并回车
- 之后显示是否确认安装
  - 按一下enter开始安装
- 之后是显示是否自动激活base环境，自动激活base会在shell的指令输入行前面显示`(base)`，和在windows上的anaconda prompt的效果一样。
  - 建议输入yes并确定，这样可以方便判断conda是否正确安装，并且不影响shell的正常使用。
- 之后是显示“为了完成更改，你需要重启shell”。
  - 输入`. ~/.bashrc`即可，和重启shell的效果相同，该指令在只能操作shell的服务器类linux系统中非常实用。
  - 该指令的说明：这个指令的效果是重新加载bash shell的配置文件
  - 该指令的更多说明：开头的点`.`是`source`的缩写，该指令其实等于`source ~/.bashrc`。
- 重新显示的命令输入行前显示`(base)`标记，说明安装成功。
- 之后可以输入`conda -V`再次验证确认是否安装成功，注意这里的V是大写。

![安装成功截图](img/安装成功截图.png)

之后可以正常使用conda的所有指令来配置虚拟环境

## 额外补充内容：离线配置环境

- 对于未连接互联网的linux服务器，需要先在可联网的linux服务器上完成一次配置，然后将conda安装包和配置完毕的虚拟环境传输到未连接互联网的服务器上。
  - 传输方法参考远程连接教学，注意你需要对可联网的linux服务器和未联网的linux分别执行`arch`或`getconf LONG_BIT`检查处理器架构
  - 两边的conda都安装完成后，在联网linux服务器上使用`conda env list`寻找到配置完成的虚拟环境文件夹位置，然后在未联网的linux服务器上使用`conda config --show envs_dirs`显示虚拟环境保存路径，将要移动的虚拟环境文件夹挪到这个指令显示的路径的其中一个里。
