# K近邻车牌识别

**项目数据集链接：** [数据集下载链接](https://pan.baidu.com/s/1AgHi10abQqI689pMeRGxbQ?pwd=DTAI)

**数据集介绍：** 使用已经分割好的车牌图片作为数据集，包括数字 0-9、字母 A-Z（不包含O和I）以及省份简称共 65 个类，编号从0到 64。数据已经分成了训练集和测试集，里面的文件夹用label编号命名，一个文件夹下的所有图片都属于该文件夹对应的类，每个图片都是20 * 20的二值化灰度图。

## 基础任务（80分）：
1. 数据预处理任务：将图片数据读入，标准化，将每个图像表示为一维向量，同时保留其对应的标签。这是进行模型训练之前的重要步骤。
2. 模型训练任务：使用 sklearn 库的 KNeighborsClassifier 类，构建 K-NN 模型，并对训练集进行训练。
3. 模型评估任务：使用模型对测试集进行预测，然后计算模型的准确率。可以使用 sklearn 库的 accuracy_score 函数来实现。
4. 参数分析任务：探究当 K 值变化时，模型在测试集上的准确率如何变化。可以绘制一个图表，显示不同 K 值对应的准确率。
5. 数据集大小影响任务：分析当训练集大小变化时，测试结果如何变化。可以尝试不同大小的训练集，记录并分析结果。

## 扩展任务（20分）：
1. 距离度量分析任务：分析在 K-NN 中使用不同的距离度量方式（如欧氏距离、曼哈顿距离等）对模型效果的影响。
2. 方法对比任务：对比平权 K-NN 与加权 K-NN 的预测效果，分析不同权重设置对结果的影响。平权 K-NN 认为所有邻居的投票权重相同，而加权 K-NN 则根据距离远近来确定权重，更近的邻居有更大的投票权。
3. 数据增强任务：考虑到车牌字符可能在不同的光照、角度和大小下出现，可以尝试进行数据增强，如旋转、缩放、剪切等操作，以提高模型的泛化能力。
4. 数据均衡任务：如果数据集中的各类别样本数量不平衡，可能会对 K-NN 的性能产生影响。可以尝试使用过采样或者欠采样的方法，来使得各类别样本数量均衡。

## Tips：

- 尝试用 K-NN 的方法对分割好的字符图像进行自动识别和转化。可以使用 sk-learn 等第三方库，不要求自己实现 K-NN。
- 图片数据的特征之一是冗余性，即一张 128x128 的图片降维到 64x64 依然不影响识别，因为图像的像素矩阵中的某个像素值与周边的像素值的相关性很强，因此相差并不大。所以，可以考虑对图像数据进行降维来增加模型的训练速度和精度。