# 创建一个conda虚拟环境并在其中安装pytorch库

- 本章节分为GPU检查、GPU版torch安装、CPU版安装三部分，安装GPU版需阅读前两部分，安装CPU版只需要阅读最后一部分，读者可按需阅读。  
- 在安装torch前请先确保已有创建的虚拟环境并且已激活环境。  
  - 重要提示：如果是使用`conda create -n aaaa`的语句创建新环境，默认不会立刻安装python，conda会在首次使用`conda install`指令安装包时根据依赖关系选择兼容的python版本进行安装。这会导致一个问题：在新建环境后立刻执行`pip`指令时，会由于当前环境的pip尚未安装，以及环境变量的优先级机制，`pip`指令会匹配到上一层环境的`pip`（例如base环境），这将导致`pip install`指令会将库安装到错误的环境中。
  - 检查方法：在激活环境后，使用`where.exe python`或`where.exe pip`查询当前环境变量中的python或pip路径是否在当前环境中。
  - 解决方案：使用`pip install`安装库之前，需要先执行`conda install python=3.10`安装python，此处版本号可以按需修改或删除（警告：当最新版python发布时，删除版本号会默认安装最新版python，这会导致出现大量依赖冲突问题）。

- conda创建环境指令：

```powershell
# 在powershell或anaconda prompt中执行环境创建指令
conda create -n aaaa python=3.10
# 遇到提示[y/n]时输入y然后点回车
# 指令执行完毕后激活环境
conad activate aaaa
```

- 补充提示：本节内容是配置一个conda虚拟环境的步骤，如果遇到无法解决的问题或误操作等，可以新建另一个环境重新进行配置尝试。conda的主要功能就是：环境配坏了方便删了重配。

```powershell
# 当环境配置出现问题时：
# 创建并激活新环境
conda create -n bbbb python=3.10
conda activate bbbb
# 删除旧环境
conda remove -n aaaa --all
```

## GPU科普

- 显卡（也叫GPU）一般有核心显卡（核显）、集成显卡（集显，已淘汰）、独立显卡（独显）三大类。显卡的功能是为电脑提供屏幕显示的内容。简而言之，没有显卡，电脑会黑屏。
  - 集显与核显：集显与核显都是使用CPU和电脑内存完成计算任务，核显是直接集成到了CPU核心中，集显则在CPU之外，但一般焊接在主板上，这两类显卡都无法从电脑上拆分出去。
  - 独显：有独立的计算和存储组件（显存），不需要使用CPU和电脑内存，独立完成计算任务，并且在大部分电脑上可以方便的单独安装或拆卸下来。市场上生产独显的两大厂商分别为NVIDIA和AMD，这两家公司生产的独立显卡分别被称为N卡和A卡，AI训练目前主流使用N卡。
- AI训练一般使用N卡，N卡在用于AI训练时的运行逻辑与作为显卡时的计算策略是不同的，并且不同型号的显卡的硬件结构也有所不同...总之最终导致的结果就是目前在安装GPU版torch时需要先查询自己显卡的cuda版本。

## GPU版torch和CPU版torch的选择

- GPU版torch只支持具有N卡的电脑，安装步骤根据显卡cuda版本和驱动版本的不同，安装步骤可能会相当繁琐。
- CPU版torch支持任何电脑，并且安装步骤方便，但是训练速度慢。
- 不要两种都安装。
- 选择安装CPU版可直接跳到本页最底部的CPU版torch安装步骤部分。
- 选择安装GPU版请继续按顺序阅读。

## 检查N卡GPU是否存在

首先确定自己的电脑有没有独立显卡。右键底部任务栏空白处->打开任务管理器->性能->GPU，检查是否存在NVIDIA开头的独立显卡。  

![GPU检查图一](img/GPU_check1.jpg)

![GPU检查图二](img/GPU_check2.jpg)

- 有NVIDIA开头的GPU：有N卡，可以正常安装cuda版pytorch
- 只有其他开头的GPU：无法安装cuda版，请选择安装CPU版
- 技术党参考：知道自己是A卡的用户也可以使用ROCM版pytorch，但是坑多且只支持Linux操作系统，非必要建议也安装CPU版。

## （可选）更新显卡驱动

少数长期不联网的电脑需要手动更新显卡驱动，这里提供更新方法  
在英伟达官网下载自动更新驱动的工具  
<https://www.nvidia.cn/geforce/drivers/>  
下载安装后使用工具更新驱动即可。  

## 检查自己的cuda版本

在powershell中输入

```powershell
nvidia-smi
```

### 指令成功执行

查看右上角自己的`CUDA Version`确定自己能安装的最高cuda版本，比如我的是12.2，所以我选择pytorch-cuda版本时不能大于12.2。  

![GPU检查图3](img/GPU_check3.jpg)

### 指令执行失败

绝大部分情况是由于电脑没有N卡，如果确定自己的电脑没有N卡，则只能安装CPU版torch

极少数情况下，该指令会被放置在一个随机命名的路径中导致无法在shell中识别
可用通过在C盘全局搜索`nvidia-smi.exe`来进行确认，将搜索到的路径添加到`path`中从而解决该问题。如果这一步操作对读者来说比较有难度，则还是建议安装CPU版torch，不要死磕。

## GPU版torch安装

进入pytorch官网：`https://pytorch.org/`并往下拉，找到以下页面：

![pytorch官网安装指令页面](img/pytorch官网安装页示意图.png)

cuda版本和镜像源的额外说明：

- cuda说明
  - 上图中的cuda版本选项推荐在不高于自己的`CUDA Version`版本的基础上尽可能高，在此基础上在上方页面选择安装版本。
- 使用镜像源安装GPU版
  - 请将下方示例指令中的`torch==2.5.1`修改为上图中蓝框中或你需要的torch版本，将示例指令末尾的链接中的`cu124`修改为你的cuda版本。其中`cu124`就是`cuda 12.4`的意思。修改原理在上图中已给出说明。
  - 示例指令：`pip install torch==2.5.1 torchvision torchaudio --index-url https://pypi.tuna.tsinghua.edu.cn/simple --extra-index-url https://download.pytorch.org/whl/cu124`
  - 提示：使用pip前请确保当前环境存在python，具体方法在本文开头已给出。
## CPU版torch安装

要求：

- 已激活虚拟环境。
- 若使用codna安装，需要已正常安装conda并按要求配置好镜像源（如果需要）。
- 若使用pip安装，需要确保当前环境存在pip和python，检查方法：执行`where.exe pip`检查，查看当前激活的pip的路径是否存在并且在第一行。

使用conda安装：

```powershell
# 使用torch的官方源下载：
conda install pytorch torchvision torchaudio cpuonly -c pytorch
# 使用国内镜像源下载（要先进行conda换源操作）：
conda install pytorch torchvision torchaudio cpuonly
```

使用pip安装：

```powershell
# 使用pip的默认源下载
pip install torch torchvision torchaudio
# 使用pip临时指定镜像源下载(CPU版就不需要像GPU版那样需要另一个链接指定依赖了)
pip install torch torchvision torchaudio -i https://pypi.tuna.tsinghua.edu.cn/simple
```

## 检查pytorch安装情况

pytorch安装完成后，>>**重启powershell**<<然后输入下方指令并稍等片刻，返回cuda支持情况以确定pytorch是否安装成功。

```powershell
python -c "import torch;print(torch.cuda.is_available())"
# 安装GPU版pytorch返回应当为True  
# 安装CPU版pytorch返回应当为False  
```

```powershell
python -c "import torch;print(torch.__version__)"
# 正常情况应当返回torch版本2.x.x，过旧的cuda版本可能会是1.x.x
```

若输出符合预期则pytorch配置完毕。若输出与预期不符则可能为环境配置步骤中的某步出问题，需要进行检查。

## 安装其他第三方库

- 第三方库的安装主要要注意点在于安装时的名称与常用称呼可能不一致，例如`sklearn`在安装时要使用全称`scikit-learn`。
- 以下是一些深度学习常用第三方库的安装指令，注意不要安装到base环境中。

```powershell
conda install numpy
conda install pandas
conda install matplotlib
conda install seaborn
conda install scipy
conda install scikit-learn
# 也可以合并为一句
conda install numpy,pandas,matplotlib,seaborn,scipy,scikit-learn
```
