# 电脑常识——开发者相关

## 操作系统篇

### windows操作系统和linux操作系统介绍

#### 什么是操作系统

你可以发现，你的手机上的软件、文件和电脑端的不完全通用，不同品牌的手机之间也不通用，例如苹果手机和华为手机，这就是因为手机和电脑使用了不同的操作系统。

常见的操作系统有：windows、安卓、ios、鸿蒙、linux、苹果的mac等。

linux操作系统是和windows不同的另一种开源操作系统，手机的安卓系统、ios、mac

## 概念介绍——操作系统

### 环境配置介绍

- 环境：编程时，代码只是一个文本文件。无论是代码编写过程中，还是代码执行过程中，都需要提供各种工具和资源。例如用色彩将语法高亮、方便的自动提示、语法纠错、将代码转换成程序的工具（编译器/解释器）、其他工具包及其路径与调用方法等。这些编写和执行代码所需的各种工具与资源比较笼统的统称为“环境”。
- 环境配置：配置（1）一个方便自己编写代码的环境（2）一个能让自己的代码跑起来的环境。

### shell：powershell和cmd

- cmd：全称command prompt，在一些电脑上显示的中文名为“命令提示符”。cmd源于早期DOS系统，功能原始简单但稳定可靠。
- powershell：推出于2006年，是cmd的升级版本（只要是cmd上能运行的指令powershell上都能运行），powershell功能更强，但由于更复杂所以也更容易报错。
- shell：cmd与powershell都是windows系统自带的shell。
  - 不同操作系统拥有不同的shell，例如Bash是Linux中最常见的Shell。
  - 由于兼容性和用户习惯等原因，windows在推出powershell之后并没有弃用cmd，因此windows操作系统目前同时存在两种shell。
- shell的别称：终端、prompt、命令行工具，这几个称呼是同义词。
- 在只涉及到基本功能时，powershell和cmd两者可以互换使用，区别不大。

小技巧：点击组合键win+r，输入cmd或powershell即可打开对应shell。  

### 环境变量

#### 简介

- 环境变量可以看作在终端中启动其他程序的快捷方式，类似桌面上的快捷方式。  
- 环境变量指定的如果是一个文件夹的目录，则表示将该文件夹内的所有可执行的文件加入环境变量。  
- 将一个路径添加入环境变量，则使用powershell或cmd执行该路径内的程序时便不需要再指定路径，只需要输入文件名即可。
- shell在获得一个指令时会在所有环境变量的目录中搜索匹配，执行第一个搜索到的匹配项。（也就是即使存在多个匹配项也只会执行第一个匹配项）
- 注意环境变量与接下来要提到的环境配置、虚拟环境等概念不同，注意区分。

### 文件名后缀与文件类型介绍

#### 文件名后缀机制简介  

- 操作系统的文件命名一般都带有后缀并根据后缀名来识别文件类型。这个机制目前所有设备的操作系统通用。
- 后缀的识别方式是由文件名的最后一个点“.”识别。比如.exe执行程序，.txt纯文本，jpg和png格式的图片，.mp3音频，.html网页。  
- 早期的文件名后缀只支持三个字符，而现在可以支持更多字符，因此现在存在不同后缀名具有相同意义的情况：如`.hml`和`.html`，`.yml`和`.yaml`都是同类型的文件。
- 文件类型有时存在兼容情况，你可以尝试将一个.txt文件重命名为.html文件然后打开看看会发生什么事。

#### （可选）设置显示文件的后缀名  

- windows操作系统一般默认隐藏文件名后缀，因此需要设置windows显示文件名后缀或直接在vscode中查看和设置文件名后缀。  
- 推荐方法：在`windows设置->更新和安全->开发者选项->勾选显示文件扩展名和隐藏文件`这两项，可以顺便勾选最下方`更改执行策略，以允许本地powershell脚本在未签名的情况下运行`项。  
- 或在`控制面板->外观和个性化->文件资源管理器/文件夹`选项中也可以寻找到。  

#### 常见编程类文件格式

`.txt`是最基本的文本格式，代码和一些表格、文本数据集都可以用txt格式打开，即使它们不以`.txt`结尾。以下格式都可以用`.txt`格式打开：

- `.py`：python的代码文件  
- `.ipynb`：jupyter文件，可以以代码块的形式分段执行代码、编辑或展示，适用于教学、做笔记、调试等场景。
- `.md`
  markdown文件：很适合作为笔记的文件类型，经常被用作readme文件的格式。学习成本不到10分钟即可入门，强烈推荐在完成环境配置之后在jupyter插件中尝试一下。
- `.CSV`
  表格类数据的常用格式，本质上是使用英文逗号“,”和换行符作为间隔符的纯文本文件，结构为行与列的表格，因此具有非常高的兼容性。既可以在excel表格编辑，也可以用txt的格式打开，还可以用pandas库直接读取和处理。  
- `.json`
  一种源于javascript的用于存储和读取文本信息的语法，由于易于人阅读和编写而受到追捧，目前已经成为C++、python等很多语言都支持的通用格式。
- `.yaml`
  "Yet Another Markup Language"（仍是一种标记语言）和"YAML Ain't a Markup Language"（YAML不是一种标记语言）的递归缩写。
  只不过是一种与.json格式功能类似，但语法不同的另一种格式。
  `.json`和`.yaml`目前经常被用于存储各种配置文件和非表格类的文本类数据集，经常可以见到config.jsom或config.yaml等名称的文件（config：设置）。你可以通过以文本格式打开`.json`和`.yaml`文件查看内容。

上面这些文件格式也都是在深度学习环境中经常遇到的，粗略阅读留下一些印象会为未来的学习减少很多阻力。
