# 在开始linux环境配置前，需要明确以下几个问题

## 请确认是否有linux环境配置需求

- linux环境配置不是新手村的必要内容，本章节内容是针对有linux使用需求的同学进行准备的。
- 如何判断自己是否需要配置linux环境
  - 如果自己有符合下方使用场景的情况，说明需要配置。
  - 如果自己都不知道自己是否需要配置linux环境，则不需要配置。
  - 如果嫌新手村的windows配置环境过程太简单了，并且对linux感兴趣，可以考虑学一下。
    - 单纯非使用需求只是学习的话，请选择下方场景1的配置路线。
    - 如果你是linux的初学者，请另外阅读linux入门文档。

### 常见的linux使用场景介绍

- 场景1：使用windows操作系统时遇到使用linux的需求。
  - 场景1的解决方案：推荐使用WSL2，不推荐双系统或虚拟机。
  - 本文档提供了wsl2的配置教学作为配套。
  - 本文档不提供双系统或虚拟机的配置方案，但如果你已经完成了双系统或虚拟机的配置，可以在场景1和场景4中二选一。
- 场景2：因业务、学习等需求而需要远程连接实验室、个人、公司的linux服务器
- 场景3：租用云GPU，云GPU一般搭建在linux服务器上。
  - 场景3会以点头云GPU作为示例，视频课中也有介绍。
- 场景4：使用了linux桌面操作系统的电脑并希望在该linux桌面操作系统中配置环境
  - 要使用另一台电脑连接该电脑时，属于场景2。

## 本文档的教学目标

本文档的撰写目的是教会大家能够掌握在linux操作系统中配置和使用深度学习环境的方法。

“配置和使用深度学习环境”具体来说包括：

- 在linux上完成conda的安装
- 使用conda创建虚拟环境
- 在虚拟环境中安装torch和其他深度学习所需要的python包
- 使用vscode操作linux系统，完成以下操作
  - 编写和使用linux上的虚拟环境执行代码文件
  - 上传和下载文件（例如项目代码文件和数据集）

## 上述不同使用场景的同学如何食用本文档

首先请完成“打开linux的bash shell”这一步操作

说明：bash shell在linux中的功能和powershell/cmd在windows中的功能定位是一样的，都可以单独打开或使用vscode的终端窗口打开。

- 直接打开bash shell
  - 对于场景1，需要先完成wsl的配置教学
  - 对于场景2，你应该能够自行解决
  - 对于场景3，一般在云GPU平台会提供终端按钮之类的，如果没有那就下面这种方法
- 使用vscode远程连接在终端打开bash shell
  - 对于场景1，在直接打开bash shell的基础上，再完成远程连接的配置教学（就一点）
  - 对于场景2，在直接打开bash shell的基础上，再完成远程连接的配置教学
  - 对于场景3，完成远程连接的配置教学
- 远程连接配置教学很简单，并且针对上述不同配置场景进行了分类，请按需食用。

你可以在能够直接打开bash shell的基础上先学习如何使用vscode远程连接在终端打开bash shell再学习conda的环境配置，或者反过来先完成conda的环境配置再学习使用vscode远程连接，都可以。

- 对于场景4，直接按照linux版vscode即可，不需要远程连接，单独有一篇文档介绍linux版vscode的安装。conda的配置则依然遵循conda的环境配置

注：一会把“conda的环境配置”和“vscode远程连接”替换成文件夹的名字。

## 另外

linux操作系统环境配置与windows不同，可能需要全程都在shell页面进行操作，因此为了通用性上的考虑，本文档默认linux场景123只有一个bash shell页面。只有场景4的vscode安装涉及到了图形用户界面(毕竟vscode没图形交互界面用不了。CLI版除外，但是这个超纲了。)

本文档测试时使用的linux操作系统类型为ubuntu。

为什么没有pycharm：因为pycharm远程连接功能是付费的。
