# 某闯关类手游用户流失预测

**项目数据集链接：** [数据集下载链接](https://pan.baidu.com/s/1AgHi10abQqI689pMeRGxbQ?pwd=DTAI)

## 作业说明：

根据给出的实际数据（包括用户游玩历史，关卡特征等），预测测试集中的用户是否为流失用户（二分类）；
方法不限，使用百度云进行评测，评价指标使用 AUC；
提交代码与实验报告，报告展示对数据的观察、分析、最后的解决方案以及不同尝试的对比等；
最终评分会参考达到的效果以及对所尝试方法的分析。

## 数据概览：

- 本次使用的是一个休闲类闯关手游的数据，用户在游戏中不断闯关，每一关的基本任务是在限定步数内达到某个目标。
- 次周的留存情况是公司关注的一个重点，数据选取了 2020.2.1 注册的所有用户在 2.1-2.4 的交互数据，数据经过筛选保证这些注册用户在前四日至少有两日登录。
- 流失的定义参照次周（2.7-2.13）的登录情况，如果没有登录为流失。
- 数据以更原始的数据记录形式呈现，共包含 5 个文件：
- train.csv  
  训练集用户,包括用户 id(从 1 开始)以及对应是否为流失用户的 label(1:流失,0:留存)。这里对应了2774~10931的user_id。
  
- dev.csv  
  验证集格式和训练集相同,主要为了方便离线测试与模型选择。这里对应了10932~13589的user_id。
  
- test.csv  
  测试集只包含用户 id,任务就是要预测这些用户的流失概率。要预测的是1~2773的user_id。
  
- level_seq.csv  
  这个是核心的数据文件,包含用户游玩每个关卡的记录,每一条记录是对某个关卡的一次尝试,具体每列的含义如下:
  
  - user_id :用户 id,和训练、验证、测试集中的可以匹配
  - level_id :关卡 id 
  - f_success :是否通关(1:通关,0:失败)
  - f_duration :此次尝试所用的时间(单位 s)
  - f_reststep :剩余步数与限定步数之比(失败为 0)
  - f_help :是否使用了道具、提示等额外帮助(1:使用,0:未使用)
  - time :时间戳
  
- level_meta.csv
  每个关卡的一些统计特征,可用于表示关卡,具体每列的含义如下: 
  
  - f_avg_duration :平均每次尝试花费的时间(单位 s,包含成功与失败的尝试)
  - f_avg_passrate :平均通关率 
  - f_avg_win_duration :平均每次通关花费的时间(单位 s,只包含通关的尝试)
  - f_avg_retrytimes :平均重试次数(第二次玩同一关算第 1 次重试)
  - level_id :关卡 id,可以和 level_seq.csv 中的关卡匹配

## Tips：

- 基本的分析和建模思路可以是：根据用户的评论内容和其他相关信息为每个用户提取特征 → 接下来结合标签（例如评论质量）构建表格式的数据集 → 然后使用不同的机器学习模型（例如集成学习方法）进行训练和测试。
- 如果数据量太大，导致运行时间过长，可以考虑先在一个采样的小训练集上进行模型调参和验证，然后再应用到整个数据集。
- 集成多种模型通常可以提高预测性能，达到更优的效果。例如，使用 Bagging 和 AdaBoost 等集成方法可以整合多个基分类器的强项，增强模型的泛化能力。
- 还可以考虑使用各种开源工具和库（例如 scikit-learn）来加速开发和实验过程，这些工具通常提供了许多预处理、特征工程和模型训练的便捷功能。