# 基于集成学习的 Amazon 用户评论质量预测

**项目数据集链接：** [数据集下载链接](https://pan.baidu.com/s/1AgHi10abQqI689pMeRGxbQ?pwd=DTAI)

**案例简介：** 在进行线上商品挑选时，评论往往是我们十分关注的一个方面。然而目前电商网站的评论质量参差不齐，甚至有水军刷好评或者恶意差评的情况出现，严重影响了顾客的购物体验。因此，对于评论质量的预测成为电商平台越来越关注的话题，如果能自动对评论质量进行评估，就能根据预测结果避免展现低质量的评论。本案例中我们将基于集成学习的方法对Amazon现实场景中的评论质量进行预测。

##  作业说明：

本案例中需要大家完成两种集成学习算法的实现（Bagging、AdaBoost），其中基分类器要求使用 SVM 和决策树两种，因此，一共需要对比四组结果（AUC 作为评价指标）：

1. Bagging + SVM
2. Bagging + 决策树
3. AdaBoost + SVM
4. AdaBoost + 决策树

## 基本作业（80分）

1. 根据数据格式设计特征的表示。
2. 汇报不同组合下得到的 AUC。
3. 结合不同集成学习算法的特点分析结果之间的差异。
（使用 sklearn 等第三方库的集成学习算法会酌情扣分）

## 扩展作业（20分）

1. 尝试其他基分类器（如 k-NN、朴素贝叶斯，神经网络）分析不同特征的影响。
2. 分析集成学习算法参数的影响。

## Tips：

- 分析数据集
  - reviewID是用户ID
  - asin是商品ID
  - reviewText是评论内容
  - overall是用户对商品的打分
  - votes_up是认为评论有用的点赞数
  - votes_all是该评论得到的总点赞数
  - label是标签